const express = require("express");
const router = express.Router();
const multer = require("multer");
const studentController = require("../../controllers/studentController");

// Configure multer
const storage = multer.diskStorage({
  destination: "uploads/temp/",
  filename: (req, file, cb) => {
    cb(null, Date.now() + "-" + file.originalname);
  },
});

const upload = multer({ storage, limits: { fileSize: 5 * 1024 * 1024 } });

// Routes
router.post("/", upload.single("photo"), studentController.createStudent);
router.get("/", studentController.listStudents);
router.get("/teacher/:teacherId", studentController.getStudentsByTeacher);
router.get("/:id", studentController.getStudentById);
router.put("/:id", upload.single("photo"), studentController.updateStudent);
router.delete("/:id", studentController.deleteStudent);

module.exports = router;
