require("dotenv").config();
const express = require("express");
const cors = require("cors");
const path = require("path");
const { connectDB } = require("./config/db");
const fs = require("fs");

// Connect to database
connectDB();

const app = express();

// Middleware
app.use(cors());
app.use(express.json());

// Ensure uploads directories exist
const uploadDirs = [
  "uploads",
  "uploads/temp",
  "uploads/webp",
  "uploads/original",
];
uploadDirs.forEach((dir) => {
  const dirPath = path.join(__dirname, dir);
  if (!fs.existsSync(dirPath)) {
    fs.mkdirSync(dirPath, { recursive: true });
  }
});

// Serve images
app.use("/uploads", express.static(path.join(__dirname, "uploads")));

// Routes
app.use("/api/attendance", require("./routes/api/attendanceRoutes"));
app.use("/api/ratings", require("./routes/api/subjectRatingRoutes"));
app.use("/api/students", require("./routes/api/studentRoutes"));
app.use("/api/auth", require("./routes/api/auth"));
app.use("/api/admin", require("./routes/api/admin_routes"));

// Basic route
app.get("/", (req, res) => {
  res.json({
    message: "Al Jamia Backend API - SQLite (better-sqlite3) Version",
  });
});

const PORT = process.env.PORT || 5000;

app.listen(PORT, () => {
  console.log(`🚀 Server running on port ${PORT}`);
});
