const SubjectRating = require("../models/SubjectRating");

// GET all ratings of student
exports.getStudentRatings = async (req, res) => {
  try {
    const { studentId } = req.params;

    const grouped = await SubjectRating.getGroupedByStudent(studentId);

    res.json(grouped);
  } catch (err) {
    res.status(500).json({ error: "Failed to load ratings" });
  }
};

// SAVE rating
exports.saveRating = async (req, res) => {
  try {
    const { studentId } = req.params;
    const { subject, date, rating } = req.body;

    await SubjectRating.upsert({
      studentId,
      subject,
      date: new Date(date).toISOString().split("T")[0],
      rating,
    });

    res.json({ message: "Rating saved" });
  } catch (err) {
    res.status(500).json({ error: "Failed to save rating" });
  }
};
