const Attendance = require("../models/Attendance");

// GET attendance for student (monthly or all)
exports.getStudentAttendance = async (req, res) => {
  try {
    const { studentId } = req.params;
    const { month, year } = req.query;

    let options = {};
    if (month && year) {
      const start = new Date(year, month - 1, 1).toISOString().split("T")[0];
      const end = new Date(year, month, 0).toISOString().split("T")[0];
      options = { startDate: start, endDate: end };
    }

    const records = Attendance.findByStudent(studentId, options);

    res.json(
      records.map((r) => ({
        date: r.date,
        isPresent: Boolean(r.isPresent),
      })),
    );
  } catch (err) {
    res.status(500).json({ error: "Failed to load attendance" });
  }
};

// MARK / UPDATE attendance
exports.markAttendance = async (req, res) => {
  try {
    const { studentId } = req.params;
    const { date, isPresent } = req.body;

    const record = Attendance.upsert({
      studentId,
      date: new Date(date).toISOString().split("T")[0],
      isPresent: isPresent ? 1 : 0,
      markedBy: req.user?.id,
    });

    res.json({
      message: "Attendance saved",
      record,
    });
  } catch (err) {
    res.status(500).json({ error: "Failed to mark attendance" });
  }
};
